import json

with open("node_eval_results.json", 'r') as f:
    node_results = json.load(f)

qualified_args = {}
for args, result in node_results.items():
    sr = result["mean_sr"]
    cand_nums = result["mean_num"]

    if sr < 0.4:
        continue
    qualified_args[args] = result

data = [(args, result["mean_sr"], result["mean_num"]) for args, result in qualified_args.items()]

# Find the non-dominated subset
pareto_front = []
for i, (a1, sr1, num1) in enumerate(data):
    dominated = False
    for j, (a2, sr2, num2) in enumerate(data):
        if i != j and sr2 >= sr1 and num2 <= num1 and (sr2 > sr1 or num2 < num1):
            dominated = True
            break
    if not dominated:
        pareto_front.append(a1)
        print(f"Adding {a1} to pareto front: sr={sr1}, num={num1}")

print(f"Pareto front: {len(pareto_front)}")

with open("qualified_args.json", 'w') as f:
    json.dump(pareto_front, f, indent=4)


